<?php

/**
 *	App Name	: Pos Kasir Pro	
 *	Developed by: Team Cepat Online
 *	Website		: https://cepatonline.com
 *	Year		: 2022-2022
 */

namespace App\Models;

class JenisHargaModel extends \App\Models\BaseModel
{
	public function deleteData()
	{
		$result = $this->db->table('jenis_harga')->delete(['id_jenis_harga' => $_POST['id']]);
		return $result;
	}

	public function getJenisHargaById($id)
	{
		$sql = 'SELECT * FROM jenis_harga WHERE id_jenis_harga = ?';
		$result = $this->db->query($sql, trim($id))->getRowArray();
		return $result;
	}

	public function saveData()
	{
		$data_db['nama_jenis_harga'] = $_POST['nama_jenis_harga'];
		$data_db['deskripsi'] = $_POST['deskripsi'];

		if ($_POST['id']) {
			$query = $this->db->table('jenis_harga')->update($data_db, ['id_jenis_harga' => $_POST['id']]);
		} else {
			$query = $this->db->table('jenis_harga')->insert($data_db);
		}

		if ($query) {
			$result['status'] = 'ok';
			$result['message'] = 'Data berhasil disimpan';
		} else {
			$result['status'] = 'error';
			$result['message'] = 'Data gagal disimpan';
		}

		return $result;
	}

	public function countAllData()
	{
		$sql = 'SELECT COUNT(*) AS jml FROM jenis_harga';
		$result = $this->db->query($sql)->getRow();
		return $result->jml;
	}

	public function getListData()
	{

		$columns = $this->request->getPost('columns');

		// Search
		$where = ' WHERE 1=1 ';
		$search_all = @$this->request->getPost('search')['value'];
		if ($search_all) {

			foreach ($columns as $val) {

				if (strpos($val['data'], 'ignore_search') !== false)
					continue;

				if (strpos($val['data'], 'ignore') !== false)
					continue;

				$where_col[] = $val['data'] . ' LIKE "%' . $search_all . '%"';
			}
			$where .= ' AND (' . join(' OR ', $where_col) . ') ';
		}

		// Order		
		$order_data = $this->request->getPost('order');
		$order = '';
		if (@strpos($_POST['columns'][$order_data[0]['column']]['data'], 'ignore_search') === false) {
			$order_by = $columns[$order_data[0]['column']]['data'] . ' ' . strtoupper($order_data[0]['dir']);
			$order = ' ORDER BY ' . $order_by;
		}

		// Query Total Filtered
		$sql = 'SELECT COUNT(*) AS jml_data FROM jenis_harga ' . $where;
		$total_filtered = $this->db->query($sql)->getRowArray()['jml_data'];

		// Query Data
		$start = $this->request->getPost('start') ?: 0;
		$length = $this->request->getPost('length') ?: 10;
		$sql = 'SELECT * FROM jenis_harga 
				' . $where . $order  . ' LIMIT ' . $start . ', ' . $length;
		$data = $this->db->query($sql)->getResultArray();

		return ['data' => $data, 'total_filtered' => $total_filtered];
	}
}
